#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: cms_dumpdata.py 12021 2020-03-26 11:31:31Z Trista $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Trista $
# $Date: 2020-03-26 19:31:31 +0800 (週四, 26 三月 2020) $
# $Revision: 12021 $

import datetime
import logging

from aldryn_newsblog.models import Article, ArticleTranslation
from cms.models.pluginmodel import CMSPlugin
from cms.models.pagemodel import Page, TreeNode
from djangocms_forms.models import Form, FormDefinition
from django.conf import settings
from django.core.management.base import BaseCommand
from django.db import transaction

from Zephyrus.blog_extension.models import CallToActionModel
from Zephyrus.blog_extension import settings as _settings 

logger = logging.getLogger(__name__)

class Command(BaseCommand):

    help = 'Add call to action plugin to exsisted article'

    @transaction.atomic
    def handle(self, *args, **options):
    
        articlesTranslations = ArticleTranslation.objects.all()
        amount = 0
        for articleTranslation in articlesTranslations:
            
            article = Article.objects.get(id=articleTranslation.master_id)
            cmsPlugin = CMSPlugin.objects.filter(
                placeholder_id=article.content_id,
                plugin_type = 'CallToActionPlugin',
                language = articleTranslation.language_code,
            )
            if cmsPlugin.exists():
                pass
            else:
                callToActionModel = CallToActionModel()
                callToActionModel.save()

                cmsPlugin = CMSPlugin.objects.get(id=callToActionModel.cmsplugin_ptr_id)
                cmsPlugin.language = articleTranslation.language_code

                cmsPlugin.plugin_type = 'CallToActionPlugin'
                cmsPlugin.placeholder_id = article.content_id
                cmsPlugin.save()
                
                if CMSPlugin.objects.filter(parent_id=cmsPlugin.id).exists():
                    pass
            
                # the child plugin actionform is not created
                else:
                    
                
                    # test whether the thank page is created
                    
                    thankNode = TreeNode.objects.filter(
                        cms_pages__title_set__slug='thank',
                        cms_pages__template=_settings.THANK_DEFAULT_TEMPLATE
                    ).distinct()
                    if thankNode.exists():
                        redirectPage = thankNode.all()[0].cms_pages.all()[0]
                    else:
                        
                        thankNode = TreeNode(site_id=cmsPlugin.page.node.site_id)
                        lan = cmsPlugin.language
                        redirectPage = Page(node=thankNode, 
                                            template=_settings.THANK_DEFAULT_TEMPLATE, 
                                            created_by=request.user, 
                                            languages=lan)
                        redirectPage.save()
                        pageTitle = Title(language=lan, title='Thank', slug='thank', page=redirectPage, 
                                           path=f'{obj.page.title_set.all()[0].path}/thank')
                        pageTitle.save()
                        redirectPage.publish(language=lan)

                    
                    time = datetime.datetime.now()
                    now = time.strftime("%m/%d/%Y|%H:%M:%S")
                    name = f'{articleTranslation.slug}-auto-{now}'
                    
                    referencedForm = Form(name=name)
                    referencedForm.save()
                    formDefinition = FormDefinition(
                        name=name,
                        success_redirect=True,
                        page_redirect=redirectPage,
                        form_template=_settings.CALL_TO_ACTION_FORM_DEFAULT_TEMPLATE,
                        plugin_reference=referencedForm,
                        email_subject=_settings.CALL_TO_ACTION_EMAIL_SUBJECT
                    )
                    formDefinition.save()


                    

                    formPlugin = CMSPlugin.objects.get(id=formDefinition.cmsplugin_ptr_id)


                    formPlugin.language = cmsPlugin.language

                    formPlugin.position=0
                    formPlugin.plugin_type=u'ActionForm'
                    formPlugin.placeholder=cmsPlugin.placeholder
                    formPlugin.parent=cmsPlugin
                    formPlugin.depth= cmsPlugin.depth + 1
                    formPlugin.path = cmsPlugin.path + '0001'
                    formPlugin.save()
                    
                    logger.debug(
                        f'Add plugin in article id: {article.id} title: articleTranslation: {articleTranslation.title}'
                    )
                    amount = amount + 1
                    
        logger.info(f'Finished adding plugin in {amount} existed articles')

                
            
        
