#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: urls.py 11593 2019-05-29 06:23:49Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License, 
# you may not use this file except in compliance with the License. 
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and 
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-05-29 15:23:49 +0900 (週三, 29 五月 2019) $
# $Revision: 11593 $ 

from django.conf import settings
from django.conf.urls import url

from . import views

urlpatterns = [
    url(r"^auth/token/create/$", views.FacebookAccessTokenCreateView.as_view(), name='facebookAccessTokenCreate'),
    url(r"^auth/token/return/$", views.FacebookAccessTokenReturnView.as_view(), name='facebookAccessTokenReturn'),
    url(r'^auth/redirect/$', views.AuthorizationRedirectView.as_view(), name='facebookAuthorizationRedirect'),
    url(r'^auth/$', 
        views.FacebookAuthorizationView.as_view(), name='facebookAuthorization')
]

if "Zephyrus.comment" in settings.INSTALLED_APPS:
    urlpatterns += [
        url(r'^webhook/', 
            views.FacebookWebHookView.as_view(), name='facebookWebhook'),
    ]