#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: LocalTest.py 11534 2019-05-10 09:33:43Z Andy $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Andy $ (last)
# $Date: 2019-05-10 17:33:43 +0800 (週五, 10 五月 2019) $
# $Revision: 11534 $

from Iuppiter import test as TestUtil

TestUtil.chdirToRootDir()

import os
import unittest

import Iuno.cloud
from Iuno.cloud.queue.backend import Local

class LocalTest(unittest.TestCase):

    def testBySettings(self):
        """
        Test Local backend configuration by settings.
        """
        settings = {
            'INSTALLED_APPS': (),
        }

        Iuno.cloud.attachSettings(settings, services=('queue',),
                                  serviceSettings={
                                      'queue': {
                                          'backendClasses': (Local.Backend,),
                                      },
                                  },
                                  cache=True, loggingLevel='DEBUG')

        settings = {
            'INSTALLED_APPS': (),
            'IUNO_CLOUD_QUEUE_BACKEND_HOST': 'naga.servehttp.com',
            'HOST_OS': 'windows',
            'BROKER_USER': 'test',
            'BROKER_PASSWORD': 'test',
        }

        Iuno.cloud.attachSettings(settings, services=('queue',),
                                  serviceSettings={
                                      'queue': {
                                          'backendClasses': (Local.Backend,),
                                      },
                                  },
                                  cache=True, loggingLevel='DEBUG')
        
        self.assertEqual(settings['BROKER_URL'], 
                         'amqp://test:test@naga.servehttp.com:5672/')
        self.assertEqual(settings['CELERY_RESULT_BACKEND'], 
                         'redis://:25025529@naga.servehttp.com:6379')

    def testByConfig(self):
        """
        Test Local backend configuration by configuration file.
        """
        settings = {
            'INSTALLED_APPS': (),
            'IUNO_CLOUD_QUEUE_LOCAL_CONFIG':
                os.path.abspath(os.path.join(os.path.dirname(__file__),
                                'LocalTest.ini'))
        }

        Iuno.cloud.attachSettings(settings, services=('queue',),
                                  serviceSettings={
                                      'queue': {
                                          'backendClasses': (Local.Backend,),
                                      },
                                  },
                                  cache=True, loggingLevel='DEBUG')

        self.assertEqual(settings['BROKER_URL'], 
                         'amqp://test:test@127.0.0.1:5672/')
        self.assertEqual(settings['CELERY_RESULT_BACKEND'], 
                         'redis://:redis@127.0.0.1:6379')

if __name__ == "__main__":
    unittest.main()
