#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Nuwa.py 9439 2015-09-25 08:01:30Z Eric $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $ (last)
# $Date: 2015-09-25 16:01:30 +0800 (週五, 25 九月 2015) $
# $Revision: 9439 $

from Iuno.cloud.backend import BaseBackend
from Iuno.cloud.logging.backend import BackendMixin

class Backend(BaseBackend, BackendMixin):

    DEFAULT_PREFERRED_DOMAINS = (
        'sentry.nuwainfo.com',
    )

    SENTRY_CONFIGS = {
        'sentry.nuwainfo.com': {
            'test': {
                'SENTRY_DSN': ('threaded+https://'
                    '419b30ac13704aabb4efaacfa99c5736:'
                    '301644578dc44afaaef54940223686f8@'
                    'sentry.nuwainfo.com/3?timeout=60'),
            },
            'mail': {
                'SENTRY_DSN': ('threaded+https://'
                    '5848523a420a4014ae88e5de2598ac02:'
                    '9186279420b24eb5a4b07fe70552348b@'
                    'sentry.nuwainfo.com/4?timeout=60'),
            },          
        },
    }
