#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Util.py 9438 2015-09-25 07:43:20Z Eric $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $
# $Date: 2015-09-25 15:43:20 +0800 (Fri, 25 Sep 2015) $
# $Revision: 9438 $
import os

from django.test import TestCase

from Iuno import attachSettings

class TestAttachSettings(TestCase):
    
    def testEmptyTemplatesSettings(self):
    
        settingsContent = {
                               
            'INSTALLED_APPS' : (
                'django.contrib.admin',
                'django.contrib.auth',
                'django.contrib.contenttypes',
                'django.contrib.sessions',
                'django.contrib.messages',
                'django.contrib.staticfiles',
            ),
            'MIDDLEWARE_CLASSES' : (
                'django.contrib.sessions.middleware.SessionMiddleware',
                'django.middleware.common.CommonMiddleware',
                'django.middleware.csrf.CsrfViewMiddleware',
                'django.contrib.auth.middleware.AuthenticationMiddleware',
                ('django.contrib.auth.middleware.'
                 'SessionAuthenticationMiddleware'),
                'django.contrib.messages.middleware.MessageMiddleware',
                'django.middleware.clickjacking.XFrameOptionsMiddleware',
                'django.middleware.security.SecurityMiddleware',
            ),
            'ROOT_URLCONF' : "123123",
            'SECRET_KEY' : "456456",
            '__file__' : os.path.dirname(
                             os.path.dirname(os.path.abspath(__file__))),
        }

        attachSettings(settingsContent)
            
        templatesSettings = {
            'TEMPLATES' : [
                {
                    'BACKEND': ('django.template.backends.django.'
                                'DjangoTemplates'),
                    'DIRS': [],
                    'APP_DIRS': True,
                    'OPTIONS': {
                        'context_processors': [
                            'django.template.context_processors.debug',
                            'django.template.context_processors.request',
                            'django.contrib.auth.context_processors.auth',
                            ('django.contrib.messages.context_processors.'
                            'messages'),
                        ],
                    },
                },
            ],
        }
        
        self.assertEqual(settingsContent['TEMPLATES'],
                         templatesSettings['TEMPLATES'])
        
    def testMissingTemplatesSettings(self):
    
        settingsContent = {
                               
            'INSTALLED_APPS' : (
                'django.contrib.admin',
                'django.contrib.auth',
                'django.contrib.contenttypes',
                'django.contrib.sessions',
                'django.contrib.messages',
                'django.contrib.staticfiles',
            ),
            'MIDDLEWARE_CLASSES' : (
                'django.contrib.sessions.middleware.SessionMiddleware',
                'django.middleware.common.CommonMiddleware',
                'django.middleware.csrf.CsrfViewMiddleware',
                'django.contrib.auth.middleware.AuthenticationMiddleware',
                ('django.contrib.auth.middleware.'
                 'SessionAuthenticationMiddleware'),
                'django.contrib.messages.middleware.MessageMiddleware',
                'django.middleware.clickjacking.XFrameOptionsMiddleware',
                'django.middleware.security.SecurityMiddleware',
            ),
            'TEMPLATES' : [
                {
                    'BACKEND': ('django.template.backends.django.'
                                'DjangoTemplates'),
                },
            ],
            'ROOT_URLCONF' : "123123",
            'SECRET_KEY' : "456456",
            '__file__' : os.path.dirname(
                 os.path.dirname(os.path.abspath(__file__))),
                         
        }
        
        
        settingsContent['__file__'] = os.path.dirname(
            os.path.dirname(os.path.abspath(__file__)))
            
        attachSettings(settingsContent)
            
        templatesSettings = {
            'TEMPLATES' : [
                {
                    'BACKEND': ('django.template.backends.django.'
                                'DjangoTemplates'),
                    'DIRS': [],
                    'APP_DIRS': True,
                    'OPTIONS': {
                        'context_processors': [
                            'django.template.context_processors.debug',
                            'django.template.context_processors.request',
                            'django.contrib.auth.context_processors.auth',
                            ('django.contrib.messages.context_processors.'
                             'messages'),
                        ],
                    },
                },
            ],
        }
        
        self.assertEqual(settingsContent['TEMPLATES'],
                         templatesSettings['TEMPLATES'])
