#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: LocalTest.py 9468 2015-11-02 09:33:16Z Eric $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $ (last)
# $Date: 2015-11-02 17:33:16 +0800 (週一, 02 十一月 2015) $
# $Revision: 9468 $

from Iuppiter import test as TestUtil

TestUtil.chdirToRootDir()

import os
import unittest

import Iuno.cloud
from Iuno.cloud.queue.backend import Local

class LocalTest(unittest.TestCase):

    def testBySettings(self):
        """
        Test Local backend configuration by settings.
        """
        settings = {
            'INSTALLED_APPS': (),
        }

        Iuno.cloud.attachSettings(settings, services=('queue',),
                                  serviceSettings={
                                      'queue': {
                                          'backendClasses': (Local.Backend,),
                                      },
                                  },
                                  cache=True, loggingLevel='DEBUG')

        self.assertEqual(settings['BROKER_HOST'], 'localhost')

        settings = {
            'INSTALLED_APPS': (),
            'IUNO_CLOUD_QUEUE_BACKEND_HOST': 'naga.servehttp.com',
            'HOST_OS': 'windows',
            'BROKER_USER': 'test',
            'BROKER_PASSWORD': 'test',
        }

        Iuno.cloud.attachSettings(settings, services=('queue',),
                                  serviceSettings={
                                      'queue': {
                                          'backendClasses': (Local.Backend,),
                                      },
                                  },
                                  cache=True, loggingLevel='DEBUG')

        self.assertEqual(settings['BROKER_HOST'], 'naga.servehttp.com')
        self.assertEqual(settings['CELERY_REDIS_HOST'], 'naga.servehttp.com')
        self.assertEqual(settings['BROKER_USER'], 'test')
        self.assertEqual(settings['BROKER_PASSWORD'], 'test')

        self.assertTrue('djcelery' in settings['INSTALLED_APPS'])

    def testByConfig(self):
        """
        Test Local backend configuration by configuration file.
        """
        settings = {
            'INSTALLED_APPS': (),
            'IUNO_CLOUD_QUEUE_LOCAL_CONFIG':
                os.path.abspath(os.path.join(os.path.dirname(__file__),
                                'LocalTest.ini'))
        }

        Iuno.cloud.attachSettings(settings, services=('queue',),
                                  serviceSettings={
                                      'queue': {
                                          'backendClasses': (Local.Backend,),
                                      },
                                  },
                                  cache=True, loggingLevel='DEBUG')

        self.assertEqual(settings['BROKER_HOST'], '127.0.0.1')
        self.assertEqual(settings['CELERY_REDIS_HOST'], '127.0.0.1')
        self.assertEqual(settings['BROKER_USER'], 'test')
        self.assertEqual(settings['BROKER_PASSWORD'], 'test')

        self.assertTrue('djcelery' in settings['INSTALLED_APPS'])

if __name__ == "__main__":
    unittest.main()
